library ieee;
USE ieee.std_logic_1164.ALL;
USE ieee.numeric_std.ALL; 

entity timemux is 
	port( 
		clk:in std_logic;
                start: in std_logic;
      		pdm_data: in std_logic_vector(3 downto 0);
		pdm_data_mux:out std_logic_vector(7 downto 0); --output is 8 bits
                data_tvalid:out std_logic;
                data_tlast:out std_logic);
end entity timemux;
architecture arch of timemux is
 	
signal cntr: natural range 0 to 3 :=0;
		begin
--signal count:std_logic;
	
   	process(clk)
		begin 
   			 if(rising_edge(clk)) then
			   if (start = '1') then
			    if cntr =3 then
                               cntr <=0;
                            else
                               cntr <=cntr + 1;
                            end if;
			   end if;   
			end if;
	 		      
   	end process;
    
	pdm_data_mux(7)<='0';
        pdm_data_mux(6)<='0';
        pdm_data_mux(5)<='0';
        pdm_data_mux(4)<='0';
        pdm_data_mux(3)<='0';
        pdm_data_mux(2)<='0';
        pdm_data_mux(1)<= pdm_data(cntr);
        pdm_data_mux(0)<='1';
       
        data_tlast<= '1' when cntr=3 else
                     '0';
        data_tvalid<= start;

end arch;

  
	 